/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER. 
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/


#ifndef __SLL_AXI_SPI_MBMC_REGS_H__
#define __SLL_AXI_SPI_MBMC_REGS_H__

#include "target_io.h"

#define XSPI_MBMC_HAL_VERSION  "22.2.1"   //  Year.Quarter.Minor

//------------------------------------------------
// xSPI-MBMC Register Address Map on the Control Port
//
// Register addresses (on 32-bit offset) 
//------------------------------------------------

#define IOWR_SLL_XSPI_MC_REG_CAD_LEN(base_csr, data)     IOWR_32(base_csr, 0x10, data)
#define IOWR_SLL_XSPI_MC_REG_CAD_HI(base_csr, data)      IOWR_32(base_csr, 0x14, data)
#define IOWR_SLL_XSPI_MC_REG_CAD_LO(base_csr, data)      IOWR_32(base_csr, 0x18, data)
#define IOWR_SLL_XSPI_MC_REG_WDATA16(base_csr, data)     IOWR_16(base_csr, 0x1C, data)
#define IOWR_SLL_XSPI_MC_REG_WDATA32(base_csr, data)     IOWR_32(base_csr, 0x1C, data)

#define IORD_SLL_XSPI_MC_REG_RDATA(base_csr)             IORD_32(base_csr, 0x2C) 
#define IORD_SLL_XSPI_MC_REG_RDATA2(base_csr)            IORD_32(base_csr, 0x30) 

#define IOWR_SLL_XSPI_MC_REG_CMD(base_csr, data)         IOWR_32(base_csr, 0x40, data)
#define IOWR_SLL_XSPI_MC_REG_CFG(base_csr, data)         IOWR_32(base_csr, 0x44, data)
#define IOWR_SLL_XSPI_MC_REG_IRQ_MASK(base_csr, data)    IOWR_32(base_csr, 0x48, data) 
#define IOWR_SLL_XSPI_MC_REG_IRQ_CLR(base_csr, data)     IOWR_32(base_csr, 0x4C, data) 


#define IORD_SLL_XSPI_MC_REG_CFG(base_csr)               IORD_32(base_csr, 0x44) 
#define IORD_SLL_XSPI_MC_REG_IRQ_MASK(base_csr)          IORD_32(base_csr, 0x48) 
#define IORD_SLL_XSPI_MC_REG_IRQ_STATUS(base_csr)        IORD_32(base_csr, 0x4C) 

#define IORD_SLL_XSPI_MC_REG_STATUS(base_csr)            IORD_32(base_csr, 0x5C) 
#define IORD_SLL_XSPI_MC_REG_CFG_STATUS(base_csr)        IORD_32(base_csr, 0x60) 

#define IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, data)    IOWR_32(base_csr, 0x80, data)
#define IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, data)    IOWR_32(base_csr, 0x84, data)
#define IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, data)   IOWR_32(base_csr, 0x88, data)
#define IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, data)   IOWR_32(base_csr, 0x8C, data)

#define IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr, data)    IOWR_32(base_csr, 0x90, data)
#define IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr, data)    IOWR_32(base_csr, 0x94, data)
#define IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, data)   IOWR_32(base_csr, 0x98, data)
#define IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, data)   IOWR_32(base_csr, 0x9C, data)

#define IOWR_SLL_XSPI_MC_REG_DEV0_MBA0(base_csr, data)   IOWR_32(base_csr, 0xA0, data)
#define IOWR_SLL_XSPI_MC_REG_DEV0_MBA1(base_csr, data)   IOWR_32(base_csr, 0xA4, data)

#define IOWR_SLL_XSPI_MC_REG_DEV1_MBA0(base_csr, data)   IOWR_32(base_csr, 0xB0, data)
#define IOWR_SLL_XSPI_MC_REG_DEV1_MBA1(base_csr, data)   IOWR_32(base_csr, 0xB4, data)

#define IOWR_SLL_XSPI_MC_REG_MODE_CNTRL(base_csr, data)  IOWR_32(base_csr, 0xC0, data)
#define IOWR_SLL_XSPI_MC_REG_DLL_CNTRL(base_csr, data)   IOWR_32(base_csr, 0xC4, data)

#define IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, data)    IOWR_32(base_csr, 0xC8, data)
#define IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, data)    IOWR_32(base_csr, 0xCC, data)

#define IORD_SLL_XSPI_MC_REG_ID0(base_csr)               IORD_32(base_csr, 0xF0) 
#define IORD_SLL_XSPI_MC_REG_ID1(base_csr)               IORD_32(base_csr, 0xF4) 


//------------------------------------------------
// Commad Register  bit field 
//
// bit 0   - r/w mode (0 write : 1 read)
// bit 1   - register space mode (0 - memory space : 1 register space)
// bit 2   - chip select
// bit 5:3  - number of clocks pulses for Register write command Only - set to 0 for default
//
// bit 6    - 16- bit write  0  32-bit write (1) 32-bit read (always set to 1)
// bit 7    - DDR mode (0) : SPI Mode (1)
//
//
// bit 15:8 - read latency (used by PSRAM controller during Register Read) - set to 0 for default

//------------------------------------------------
#define SLL_XSPI_MC_REG_CMD_WR_MODE       0x00	
#define SLL_XSPI_MC_REG_CMD_RD_MODE       0x01

#define SLL_XSPI_MC_REG_CMD_MEM_SPACE     0x00
#define SLL_XSPI_MC_REG_CMD_REG_SPACE     0x02 

#define SLL_XSPI_MC_REG_CMD_CS0           0x00	
#define SLL_XSPI_MC_REG_CMD_CS1           0x04	

#define SLL_XSPI_MC_FLASH_CS0_WR          0x0
#define SLL_XSPI_MC_FLASH_CS0_RD          0x1

#define SLL_XSPI_MC_RAM_CS0_WR            0x2	
#define SLL_XSPI_MC_RAM_CS0_RD            0x3	

#define SLL_XSPI_MC_RAM_CS1_WR            0x6	
#define SLL_XSPI_MC_RAM_CS1_RD            0x7	

#define SLL_XSPI_MC_CS0                   SLL_XSPI_MC_REG_CMD_CS0
#define SLL_XSPI_MC_CS1                   SLL_XSPI_MC_REG_CMD_CS1

//------------------------------------------------
// Typical Commands 
//------------------------------------------------

#define SLL_XSPI_MC_CS0_4CYC_RD_CMD          (0x00000043)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY_AUTO (0x00000043)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY4     (0x00000443)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY5     (0x00000543)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY6     (0x00000643)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY7     (0x00000743)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY8     (0x00000843)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY16    (0x00001043)
#define SLL_XSPI_MC_CS0_4CYC_RD_CMD_DLY20    (0x00001443)
                                             
#define SLL_XSPI_MC_CS0_1CYC_WR_CMD          (0x0000000A)
#define SLL_XSPI_MC_CS0_3CYC_WR_CMD          (0x0000001A)
#define SLL_XSPI_MC_CS0_4CYC_WR_CMD          (0x00000042)
#define SLL_XSPI_MC_CS0_WR_CMD               (0x00000002)
#define SLL_XSPI_MC_CS0_WR16_CMD             (0x00000002)
#define SLL_XSPI_MC_CS0_WR32_CMD             (0x00000042)
                                             
#define SLL_XSPI_MC_CS1_1CYC_WR_CMD          (0x0000000E)


//------------------------------------------------
// Status Register  bit mapping 
//------------------------------------------------
#define SLL_XSPI_MC_REG_STATUS_MBMC_ERR      0x00001
#define SLL_XSPI_MC_REG_STATUS_DEC_ERR       0x00002
#define SLL_XSPI_MC_REG_STATUS_EXT_IRQ       0x00004
#define SLL_XSPI_MC_REG_STATUS_FIFO_ERR      0x00008
                                             
#define SLL_XSPI_MC_REG_STATUS_POWER_UP      0x10000  // device still in power up phase
#define SLL_XSPI_MC_REG_STATUS_RDATA_VLD     0x20000  // data returned from memory devce is valid
#define SLL_XSPI_MC_REG_STATUS_CAD_ACTIVE    0x40000  // command accepted and is being processed
#define SLL_XSPI_MC_REG_STATUS_ALL_RDATA_VLD 0x80000  // all (burst) data returned from memory devce is valid
                          
//------------------------------------------------
// IRQ MASK Register  bit fields
//------------------------------------------------
#define SLL_XSPI_MC_REG_IRQ_MBMC_ERR      0x01
#define SLL_XSPI_MC_REG_IRQ_DEC_ERR       0x02
#define SLL_XSPI_MC_REG_IRQ_EXT_IRQ       0x04
#define SLL_XSPI_MC_REG_IRQ_FIFO_ERR      0x08
#define SLL_XSPI_MC_REG_IRQ_ECC_ERR       0x10

//------------------------------------------------
// xSPI-MBMC Config Register bit mapping
//
// 25:24 addres protocol
// 21:20 device bus width
// 15:14 devce protocol
// 11: 4 Device size
//  3: 0 Devie type
//------------------------------------------------
#define XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX    4

//------------------------------------------------
// xSPI-MBMC Timing Register bit mapping
//
// 31:24 Write latency
// 23:16 Read latency
// 15: 8 Rea/Write Recovery
//  7: 4 CSH
//  3: 0 CSS
//------------------------------------------------
#define XSPI_MC_REG_DEV_TIM_READ_TACC_IDX    16

//------------------------------------------------
// Input/Output Shared PHY Multiplexer Control
//
// Ther are 4 modes present 
//
// 0 -  Input/Output in Tristate Mode 
// 1 -  Input/Output selection for external Host QSPI controller
// 2 -  Input/Output selection for SLL xSPI-MBMC controller 
// 3 -  Input/Output selection for external Target/Slave SPI controller
//------------------------------------------------
#define IOWR_SLL_XSPI_MC_MODE_DISABLE(base_csr)    IOWR_32(base_csr, 0xC0, 0x000)
#define IOWR_SLL_XSPI_MC_MODE_HQSPI(base_csr)      IOWR_32(base_csr, 0xC0, 0x101)
#define IOWR_SLL_XSPI_MC_MODE_HXSPI(base_csr)      IOWR_32(base_csr, 0xC0, 0x102)
#define IOWR_SLL_XSPI_MC_MODE_SXSPI(base_csr)      IOWR_32(base_csr, 0xC0, 0x103)

//------------------------------------------------
// Set / Reset the SLL xSPI-MBMC controller core
// Not yet implemented
//------------------------------------------------

#define IOWR_SLL_XSPI_MC_CORE_RST(base_csr)        IOWR_32(base_csr, 0xC0, 0x108)
#define IOWR_SLL_XSPI_MC_CORE_RST_CLR(base_csr)    IOWR_32(base_csr, 0xC0, 0x008)                                                    

//------------------------------------------------
// Set /Reset the Memory (forces Device Reset Pin)
//------------------------------------------------

#define IOWR_SLL_XSPI_MC_DEV_RST(base_csr)         IOWR_32(base_csr, 0xC0, 0x109)
#define IOWR_SLL_XSPI_MC_DEV_RST_CLR(base_csr)     IOWR_32(base_csr, 0xC0, 0x009)

//------------------------------------------------
// Set /Reset the controller core for use
//------------------------------------------------
#define IOWR_SLL_XSPI_MC_DEV_SETUP_RDY(base_csr)   IOWR_32(base_csr, 0xC0, 0x10A)
#define IOWR_SLL_XSPI_MC_DEV_NOT_RDY(base_csr)     IOWR_32(base_csr, 0xC0, 0x00A)

//------------------------------------------------
// Set /Reset the power down active bit on CS0
// Not yet implemented
//------------------------------------------------
#define IOWR_SLL_XSPI_MC_DEV0_PD_ACTIVE(base_csr)  IOWR_32(base_csr, 0xC0, 0x10C)
#define IOWR_SLL_XSPI_MC_DEV0_PD_CLR(base_csr)     IOWR_32(base_csr, 0xC0, 0x00C)

//------------------------------------------------
// Set /Reset the wake up bit  on CS0
// Not yet implemented
//------------------------------------------------
#define IOWR_SLL_XSPI_MC_DEV0_WAKEUP_SET(base_csr) IOWR_32(base_csr, 0xC0, 0x10D)
#define IOWR_SLL_XSPI_MC_DEV0_WAKEUP_CLR(base_csr) IOWR_32(base_csr, 0xC0, 0x00D)

//------------------------------------------------
// Set /Reset the powerdown active bit  on CS1
// Not yet implemented
//------------------------------------------------
#define IOWR_SLL_XSPI_MC_DEV1_PD_ACTIVE(base_csr)  IOWR_32(base_csr, 0xC0, 0x10C)
#define IOWR_SLL_XSPI_MC_DEV1_PD_CLR(base_csr)     IOWR_32(base_csr, 0xC0, 0x00C)

//------------------------------------------------
// Set /Reset the wake up bit  on CS1
// Not yet implemented
//------------------------------------------------
#define IOWR_SLL_XSPI_MC_DEV1_WAKEUP_SET(base_csr) IOWR_32(base_csr, 0xC0, 0x10D)
#define IOWR_SLL_XSPI_MC_DEV1_WAKEUP_CLR(base_csr) IOWR_32(base_csr, 0xC0, 0x00D)

                        

/******************************************************************************
* 
* sll_xspi_mc_reg_write_blk - Write block fo data to memory over the control port
*                             with CA format {cad_high[15:0], cad_low[31:0]} 
*
* RETURNS: None 
*
* ERRNO  : None
*/

extern void sll_xspi_mc_reg_write_blk (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd,    /* command format to issue to XSPI_MC_REG_CMD register */
  uint32_t word_count, /* number of 32-bit words to be written */
  uint32_t *data_buf   /* buffer containing data to program */
);


extern void sll_xspi_mc_reg_write_blk2 (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd,    /* command format to issue to XSPI_MC_REG_CMD register */
  uint32_t byte_count, /* number of 8-bit words to be written */
  uint8_t *data_buf    /* buffer containing data to program */
);

/******************************************************************************
* 
* sll_xspi_mc_reg_read_blk  - Read block of data from memory over the control port
*                             with CA format {cad_high[15:0], cad_low[31:0]} 
*
* RETURNS: None 
*
* ERRNO  : None
*/

extern void sll_xspi_mc_reg_read_blk (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd,    /* command format to issue to XSPI_MC_REG_CMD register */
  uint32_t word_count, /* number of 32-bit words to be written */
  uint32_t *data_buf   /* buffer containing data after read*/
);


/******************************************************************************
* 
* sll_xspi_mc_reg_write - Write 16-bit value to memory over the control port
*                         with CA format {cad_high[15:0], cad_low[31:0]} 
*       ___                                                                             _______
* CSn0     |___________________________________________________________________________|
*                   _______          _______         ________         ________       
* CK        _______|       |________|       |_______|        |_______|        |_________________
*                ______  _______  ______  _______  ______  _______  ______  _______ 
*  DQ    -------<__c0__><__c1___><__c2__><__c3___><__c4__><__c5___><__d0__><__d1___>-----

*
* RETURNS: None 
*
* ERRNO  : None
*/

extern void sll_xspi_mc_reg_write_x16 (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd,    /* command format to issue to XSPI_MC_REG_CMD register */
  uint16_t wdata       /* 16-bit data to be written */
);


/******************************************************************************
* 
* sll_xspi_mc_reg_write - Write 32-bit value to memory over the control port
*                         with CA format {cad_high[15:0], cad_low[31:0]} 
*
*        __                                                                                           _______
* CSn0     |_________________________________________________________________________________________|
*                   _______          _______         ________         ________         _______
* CK        _______|       |________|       |_______|        |_______|        |_______|       |___________
*                ______  _______  ______  _______  ______  _______  ______  _______  ______  _______
*  DQ    -------<__c0__><__c1___><__c2__><__c3___><__c4__><__c5___><__d0__><__d1___><__d2__><__d3___>
*
*
* RETURNS: None 
*
* ERRNO  : None
*/

extern void sll_xspi_mc_reg_write (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd,     /* command format to issue to XSPI_MC_REG_CMD register */
  uint32_t wdata       /* 32-bit data to be written */
);


/******************************************************************************
* 
* sll_xspi_mc_reg_read  - Read 32-bit value from memory over the control port
*                         with CA format {cad_high[15:0], cad_low[31:0]}  
*
* RETURNS: 32-bit value  
*
* ERRNO  : None
*/

extern uint32_t sll_xspi_mc_reg_read (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd     /* command format to issue to XSPI_MC_REG_CMD register */
);

extern void sll_xspi_mc_reg_read2 (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t dev_cmd,    /* command format to issue to XSPI_MC_REG_CMD register */
  uint32_t byte_count, /* Number of bytes to read */
  uint8_t  *data_buf   /* buffer containing data to program */
);

/******************************************************************************
* 
* sll_psram_reg_write  - Write 32-bit value to PSRAM(@CS1) Register over the control port
*                        with CA format {cad_high[15:0], cad_low[31:0]} 
*
* RETURNS: None 
*
* ERRNO  : None
*/

extern void sll_psram_reg_write (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low,    /* maps to CA[31:0] */
  uint32_t wdata       /* 32-bit data to be written */
);


/******************************************************************************
* 
* sll_psram_reg_read  - Read 32-bit value to PSRAM(@CS1) Register over the control port
*                        with CA format {cad_high[15:0], cad_low[31:0]} 
*
* RETURNS: 32-bit value  
*
* ERRNO  : None
*/

extern uint32_t sll_psram_reg_read (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t cad_high,   /* maps to CA[47:32] */
  uint32_t cad_low     /* maps to CA[31:0] */
);

/******************************************************************************
* 
* sll_flash_write_cmd  - Write 16-bit value to Flash(@CS0) over the control port
*                        with address offset 
*
* RETURNS: None 
*
* ERRNO  : None
*/

extern void sll_flash_write_cmd (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t offset,     /* address offset from base address (byte aligned) */
  uint16_t wdata       /* 16-bit data to be written */
);


/******************************************************************************
* 
* sll_flash_read_cmd  - Read 16-bit value from Flash(@CS0) over the control port
*                        with address offset 
*
* RETURNS: 16-bit value  
*
* ERRNO  : None
*/

extern uint16_t sll_flash_read_cmd (
  uint32_t base_csr,   /* control port base address in system */
  uint32_t offset      /* address offset from base address (byte aligned) */
);


/******************************************************************************
* 
* sll_cs0_xspi_p1_format_1a_write - Xspi Profile 1 Format 1A 
*        __                           _______
* CSn0     |__________________________|
*                   __________
* CK        _______|          |_______
*                ________  _________ 
*  DQ    -------<___c0___><___c1____>-------

* RETURNS: None 
*
* ERRNO  : None
*/
#define sll_cs1_xspi_p1_format_1a_write(b,cad_high) sll_xspi_mc_reg_write (b, cad_high, 0x00000000, SLL_XSPI_MC_CS1_1CYC_WR_CMD, 0x00000000)
#define sll_cs0_xspi_p1_format_1a_write(b,cad_high) sll_xspi_mc_reg_write (b, cad_high, 0x00000000, SLL_XSPI_MC_CS0_1CYC_WR_CMD, 0x00000000)


/******************************************************************************
* 
* sll_xspi_p1_format_1c_write - Xspi Profile 1 Format 1C 
*        __                                                              _______
* CSn0     |_____________________________________________________________|
*                   __________           __________           __________
* CK        _______|          |_________|          |_________|          |___________
*                ________  _________  ________  _________  ________  _________ 
*  DQ    -------<___c0___><___c1____><___c2___><___c3____><___c4___><___c5____>-------

* RETURNS: None 
*
* ERRNO  : None
*/

#define sll_cs0_xspi_p1_format_1c_write(b, cad_high, cad_low) sll_xspi_mc_reg_write (b, cad_high, cad_low, SLL_XSPI_MC_CS0_3CYC_WR_CMD, 0x00000000)


/******************************************************************************
* 
* sll_xspi_p1_format_1d_write_x16 - Xspi Profile 1 Format 1D (16-bit write) 
*        __                                                                            _______
* CSn0     |__________________________________________________________________________|
*                   _______          _______         ________         ________        
* CK        _______|       |________|       |_______|        |_______|        |_______
*                ______  _______  ______  _______  ______  _______  ______  _______ 
*  DQ    -------<__c0__><__c1___><__c2__><__c3___><__c4__><__c5___><__d0__><__d1___>
*
*
* RETURNS: None 
*
* ERRNO  : None
*/

#define sll_cs0_xspi_p1_format_1d_write_x16(b, cad_high, cad_low, wdata) sll_xspi_mc_reg_write_x16 (b, cad_high, cad_low, SLL_XSPI_MC_CS0_WR16_CMD, wdata)



/******************************************************************************
* 
* sll_xspi_p1_format_1d_write - Xspi Profile 1 Format 1D (32-bit write) 
*        __                                                                                           _______
* CSn0     |_________________________________________________________________________________________|
*                   _______          _______         ________         ________         _______
* CK        _______|       |________|       |_______|        |_______|        |_______|       |___________
*                ______  _______  ______  _______  ______  _______  ______  _______  ______  _______
*  DQ    -------<__c0__><__c1___><__c2__><__c3___><__c4__><__c5___><__d0__><__d1___><__d2__><__d3___>
*
*
* RETURNS: None 
*
* ERRNO  : None
*/

#define sll_cs0_xspi_p1_format_1d_write(b, cad_high, cad_low, wdata) sll_xspi_mc_reg_write (b, cad_high, cad_low, SLL_XSPI_MC_CS0_WR32_CMD, wdata)


/******************************************************************************
* 
* sll_xspi_p1_format_1d_write - Xspi Profile 1 Format 1D (32-bit write) 
*        __                                                                                                 _______
* CSn0     |________________________________________________________________________......._________________|
*                   _______          _______         ________         ________                ________
* CK        _______|       |________|       |_______|        |_______|        |_____.......__|        |___________
*                ______  _______  ______  _______  ______  _______  ______  _______         _______  _______
*  DQ    -------<__c0__><__c1___><__c2__><__c3___><__c4__><__c5___><__d0__><__d1___>-------<__dn-1_><__dn___>
*
*
* RETURNS: None 
*
* ERRNO  : None
*/

#define sll_cs0_xspi_p1_format_1d_write_blk(b, cad_high, cad_low, count, wbuffer) sll_xspi_mc_reg_write_blk (b, cad_high, cad_low, SLL_XSPI_MC_CS0_4CYC_WR_CMD,count, wbuffer)

/******************************************************************************
* 
* sll_xspi_mc_wait_pwrup_rdy  -Check xSPI-MC PowerUP ready routine
*
*
* RETURNS: OK                (0) or 
*          error on timoeout (1)
*
* ERRNO  : 1
*/

uint32_t sll_xspi_mc_wait_pwrup_rdy (uint32_t base_csr) ;


//------------------------------------------------
/* Delay Routine   */  
//------------------------------------------------
void SLL_DelayMicroseconds(int microseconds);

//------------------------------------------------
/* Controller Parameters   */  
//------------------------------------------------
typedef struct{
    uint32_t csr_base;
    uint32_t mem_freq_mhz;

    /*Device 0 parameters*/
    uint32_t dev0_name;
    uint32_t dev0_mem_base;
    uint32_t dev0_mem_size;

    /*Device 1 parameters*/
    uint32_t dev1_name;
    uint32_t dev1_mem_base;
    uint32_t dev1_mem_size;
} xSPI_MBMC_Info;
                                        
#endif /* __SLL_AXI_SPI_MBMC_REGS_H__ */

